package com.example.sefinsa_app.ui.reporteGeneral;

import androidx.annotation.RequiresApi;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.fragment.app.Fragment;

import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.utilities.CurrentFragment;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.TextView;
import android.widget.Toast;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.ReporteGeneral;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NumeroLetras;
import com.example.sefinsa_app.utilities.ReporteGeneralAdapter;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ReporteGeneralFragment extends Fragment {

    private ReporteGeneralViewModel mViewModel;

    //private ArrayList<PagosHechos> pagosHechos, pagosHechosFiltrados;
    private VolleyS vs;
    private RequestQueue requestQueue;

    private RecyclerView recyclerView;
    private ReporteGeneralAdapter reporteGeneralAdapter;
    private LinearLayoutManager linearLayoutManager;

    private AutoCompleteTextView poblacionesAutoCompleteTextView;

    private TextInputLayout tlPoblacion, tlFechaFiltro;

    private SharedPreferences sesion;

    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;

    private int previousLength;
    private boolean backSpace;

    private TextView tvPago;

    private String poblacion_id = "", fecha = "";

    private PoblacionController poblacionController;

    private FloatingActionButton fabImprimirReporte;
    private Fragment fragmento;

    private ArrayList<ReporteGeneral> reporteGeneral, reporteGeneralFiltrado;

    public static ReporteGeneralFragment newInstance() {
        return new ReporteGeneralFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        setHasOptionsMenu(true);
        return inflater.inflate(R.layout.fragment_reporte_general, container, false);
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }

    @RequiresApi(api = Build.VERSION_CODES.N)
    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                requestQueue.getCache().clear();
                getReporteDiario();
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.N)
    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "ReporteGeneralFragment";
        initElements(view);

        getReporteDiario();

        linearLayoutManager = new LinearLayoutManager(getContext());
        recyclerView.setLayoutManager(linearLayoutManager);


    }

    public void initElements(View view) {

        CurrentFragment.fragment = "ReporteDiarioFragment";

        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);

        tvPago = view.findViewById(R.id.tvPago);

        poblacionController = new PoblacionController(getActivity());
        poblacionesAutoCompleteTextView = view.findViewById(R.id.acPoblacion);
        recyclerView = view.findViewById(R.id.rvDiario);
        //pagosHechos = new ArrayList<>();
        poblaciones = new ArrayList<>();
        tlFechaFiltro = view.findViewById(R.id.tlFechaFiltro);
        fecha = tlFechaFiltro.getEditText().getText().toString();
        reporteGeneral = new ArrayList<>();

        reporteGeneralAdapter = new ReporteGeneralAdapter(getActivity(),reporteGeneral,this);
        recyclerView.setAdapter(reporteGeneralAdapter);

        fabImprimirReporte = view.findViewById(R.id.fabImprimirReporte);

        fabImprimirReporte.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                new MaterialAlertDialogBuilder(getActivity())
                    .setTitle("Imprimir reporte general")
                    .setPositiveButton("Imprimir", new DialogInterface.OnClickListener() {
                        @SuppressLint("MissingPermission")
                        @RequiresApi(api = Build.VERSION_CODES.N)
                        @Override
                        public void onClick(DialogInterface dialogInterface, int i) {

                            if (tlFechaFiltro.getEditText().getText().length() > 0) {

                                if (reporteGeneralFiltrado.size() > 0) {

                                    Date c = Calendar.getInstance().getTime();
                                    /*SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                                    String formattedDate = df.format(c);*/

                                    SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
                                    SimpleDateFormat outputFormat = new SimpleDateFormat("dd/MM/yyyy");
                                    Date date = null;
                                    try {
                                        date = inputFormat.parse(tlFechaFiltro.getEditText().getText().toString());
                                    } catch (ParseException e) {
                                        e.printStackTrace();
                                    }
                                    String fechaConvert = outputFormat.format(date);

                                    BluetoothUtils.printPhoto(R.drawable.credigrup_ticket_3);
                                    BluetoothUtils.printReporteGeneral(reporteGeneralFiltrado, fechaConvert);

                                }
                                else{
                                    Toast.makeText(getActivity(), "No hay información para imprimir", Toast.LENGTH_SHORT).show();
                                }

                            }
                            else{
                                Toast.makeText(getActivity(), "Debes ingresar un filtro de fecha", Toast.LENGTH_SHORT).show();
                            }


                        }
                    })
                    .setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    })
                    .show();

            }
        });

        /**
         *  POBLACIONES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        if(poblaciones.size() == 0){
            getPoblaciones();
        }

        poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = poblacionesAdapter.getItem(i);
                poblacion_id = poblacion.getNombre_poblacion();

                if(fecha.equals("")){
                    filtrarReportePoblacion(poblacion_id);
                }
                else{
                    filtrarReporte(fecha, poblacion_id);
                }

            }
        });

        poblacionesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !poblacion_id.equals("")) {

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    if(fecha.equals("")){
                        reporteGeneralAdapter.setListaFiltrada(reporteGeneral);
                    }
                    else{
                        filtrarReporte(fecha);
                    }

                }

            }
        });

        tlFechaFiltro.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText("Fecha");
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(getFragmentManager(), "MATERIAL_DATE_PICKER");
                materialDatePicker.addOnPositiveButtonClickListener(
                        new MaterialPickerOnPositiveButtonClickListener() {

                            @SuppressLint("SetTextI18n")
                            @Override
                            public void onPositiveButtonClick(Object selection) {

                                TimeZone timeZoneUTC = TimeZone.getDefault();
                                int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                                SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                                Date date = new Date((Long) selection + offsetFromUTC);

                                tlFechaFiltro.getEditText().setText(simpleFormat.format(date));
                                fecha = tlFechaFiltro.getEditText().getText().toString();

                                if(!poblacion_id.equals("")){
                                    filtrarReporte(fecha, poblacion_id);
                                }
                                else{
                                    filtrarReporte(fecha);

                                }
                            }
                        });
            }
        });



    }


    private void getPoblaciones()
    {
        if(poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);

                                }

                                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    0,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        }
        else{

            poblaciones = poblacionController.obtener();

            poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
            poblacionesAutoCompleteTextView.setThreshold(1);
            poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

        }
    }


    @RequiresApi(api = Build.VERSION_CODES.N)
    public void getReporteDiario() {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        reporteGeneral.clear();
        // Obtener datos de la sesión
        String empleadoId = sesion.getString("id", "");
        String perfilId = sesion.getString("perfil_id", "");

        // Validar si los datos de empleado o perfil están vacíos
        if (empleadoId.isEmpty() || perfilId.isEmpty()) {
            Toast.makeText(getActivity(), "Datos de sesión no válidos", Toast.LENGTH_SHORT).show();
            dialog.cancel();
            return; // Salir de la función si los datos no son válidos
        }


        DatabaseHelper dbHelper = new DatabaseHelper(requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String query = "";
        if (perfilId.equals("12") || perfilId.equals("13")) {
            Log.d("ReporteGeneralFragment", "ENTRO EN IF RESUMEN 12 o 13.........................");
            query = "SELECT poblaciones.nombre_poblacion, pagos.fecha_pago_realizada, clientes.nombre_completo, pagos.folio, " +
                    "pagos.concepto, " +
                    "(CASE WHEN pagos.recuperado = 0 THEN pagos.cantidad_normal_pagada ELSE pagos.recuperado END) pago, " +
                    "pagos.cantidad_multa as pago_multa, pagos.semana, rutas.nombre_ruta " +
                    "FROM pagos " +
                    "INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id " +
                    "INNER JOIN clientes ON clientes.id = prestamos.cliente_id " +
                    "INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                    "INNER JOIN rutas ON rutas.id = poblaciones.ruta_id " +
                    "WHERE pagos.empleado_id = ? AND pagos.fecha_pago_realizada IS NOT NULL";

            Cursor cursor = db.rawQuery(query, new String[]{empleadoId});

            // Procesar los resultados de la consulta
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    ReporteGeneral item = new ReporteGeneral();
                    // Obtener los datos de la fila actual
                    item.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                    item.setFecha_pago_realizada(cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago_realizada")));
                    item.setNombre_completo(cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")));
                    item.setFolio(cursor.getString(cursor.getColumnIndexOrThrow("folio")));
                    item.setConcepto(cursor.getString(cursor.getColumnIndexOrThrow("concepto")));
                    item.setPago(cursor.getString(cursor.getColumnIndexOrThrow("pago")));
                    item.setPago_multa(cursor.getString(cursor.getColumnIndexOrThrow("pago_multa")));
                    item.setSemana(cursor.getString(cursor.getColumnIndexOrThrow("semana")));
                    item.setNombre_ruta(cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")));
                    // Crear un objeto ReporteGeneral y agregarlo a la lista
                    reporteGeneral.add(item);

                } while (cursor.moveToNext());
                cursor.close();
            }

            // Mostrar el total de los pagos
            String total = "0";
            for (ReporteGeneral item : reporteGeneral) {
                total += item.getPago();
            }

            tvPago.setText("PAGO ($" + total + ")");

            // Actualizar el adaptador con los nuevos datos
            //reporteGeneralAdapter.clear();
            reporteGeneralAdapter.addAll(reporteGeneral);
            reporteGeneralAdapter.notifyItemRangeChanged(reporteGeneral.size(), 1);
            recyclerView.setVisibility(View.VISIBLE);
        } else {
            /*
            query = "SELECT poblaciones.nombre_poblacion, pagos_realizados.fecha_pago_realizada, clientes.nombre_completo, " +
                    "pagos_realizados.folio, pagos_realizados.concepto, " +
                    "(CASE WHEN pagos_realizados.recuperado = 0 THEN pagos_realizados.cantidad_normal_pagada ELSE pagos_realizados.recuperado END) pago, " +
                    "pagos_realizados.cantidad_multa as pago_multa, pagos_realizados.semana, rutas.nombre_ruta " +
                    "FROM pagos_realizados " +
                    "INNER JOIN prestamos ON prestamos.id = pagos_realizados.prestamo_id " +
                    "INNER JOIN clientes ON clientes.id = prestamos.cliente_id " +
                    "INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                    "INNER JOIN rutas ON rutas.id = poblaciones.ruta_id " +
                    "WHERE pagos_realizados.empleado_id = ? AND pagos_realizados.fecha_pago_realizada IS NOT NULL";
            */
            Log.d("ReporteGeneralFragment", "ENTRO EN ELSE RESUMEN.........................");
                vs = VolleyS.getInstance(this.getContext());
                requestQueue = vs.getRequestQueue();

                JSONObject data = new JSONObject();
                try {
                    data.put("func", "reporteGeneralAPP");
                    data.put("empleado",  sesion.getString("id", ""));
                } catch (JSONException e) {
                    e.printStackTrace();
                }

                JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                        new Response.Listener<JSONObject>() {
                            @Override
                            public void onResponse(JSONObject response) {
                                try {

                                    JSONArray data = (JSONArray) response.get("data");
                                    double total = 0;

                                    for(int i = 0; i < data.length(); i++){
                                        JSONObject obj = data.getJSONObject(i);
                                        Gson gson = new Gson();
                                        ReporteGeneral item = gson.fromJson(obj.toString(), ReporteGeneral.class);
                                        total += Utils.convertirDouble(item.getPago());
                                        reporteGeneral.add(item);
                                    }

                                    tvPago.setText("PAGO ($" + total +")");

                                    dialog.cancel();

                                    reporteGeneralAdapter.addAll(reporteGeneral);
                                    reporteGeneralAdapter.notifyItemRangeChanged(reporteGeneral.size(), 1);
                                    recyclerView.setVisibility(View.VISIBLE);

                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        }, new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                });

                request.setRetryPolicy(new DefaultRetryPolicy(
                        5000,
                        DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                        DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

                request.setShouldCache(false);
                requestQueue.add(request);

        }

        dialog.cancel();


    }


    /*
    @RequiresApi(api = Build.VERSION_CODES.N)
    public void getReporteDiario(){
        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(this.getContext());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "reporteGeneral");
            data.put("empleado",  sesion.getString("id", ""));
            data.put("empleado",  sesion.getString("perfil_id", ""));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {

                            JSONArray data = (JSONArray) response.get("data");

                            reporteGeneralAdapter.clear();
                            reporteGeneral.clear();

                            double total = 0;

                            for(int i = 0; i < data.length(); i++){
                                JSONObject obj = data.getJSONObject(i);
                                Gson gson = new Gson();
                                ReporteGeneral item = gson.fromJson(obj.toString(), ReporteGeneral.class);
                                total += Double.parseDouble(item.getPago());
                                reporteGeneral.add(item);
                            }

                            tvPago.setText("PAGO ($" + total +")");

                            dialog.cancel();

                            reporteGeneralAdapter.addAll(reporteGeneral);
                            reporteGeneralAdapter.notifyItemRangeChanged(reporteGeneral.size(), 1);
                            recyclerView.setVisibility(View.VISIBLE);

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }
    */

    public void compartirPagoReporte(ReporteGeneral rg) throws ParseException
    {
        try {
            SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat outputFormat = new SimpleDateFormat("dd/MM/yyyy");
            Date date = inputFormat.parse(rg.getFecha_pago_realizada());
            String fechaConvert = outputFormat.format(date);

            NumeroLetras numeroLetras = new NumeroLetras();

            String recibido_con_letra = numeroLetras.Convertir(rg.getPago(),
                    "", "", "",
                    "", "", true);

            String text = "--------------------------\n";
            text += "Folio: "+ (rg.getFolio() == null ? "": rg.getFolio())+"\n";
            text += "Reimpresion: " + fechaConvert+"\n";
            text += "Ruta: "+rg.getNombre_ruta()+"\n";
            text += "Poblacion: "+rg.getNombre_poblacion()+"\n";
            text += "Recibi de: "+rg.getNombre_completo()+"\n";
            text += "Cantidad: $"+rg.getPago() + "\n";
            text += "("+recibido_con_letra + "PESOS 00/100 MN)"+ "\n";
            //text += "Debe: $"+ (Double.parseDouble(pago.getBalance()) - Double.parseDouble(recibido)) + "\n";
            if(rg.getPago_multa() != "0.00") text += "Multa: $"+ rg.getPago_multa() + "\n";
            text += "Concepto: "+ (rg.getConcepto() == null ? "" : rg.getConcepto())+"\n";
            text += "--------------------------\n";

            // Generar el archivo PDF
            File pdfFile = generarPDF(text);

            // Compartir el archivo PDF
            compartirPDF(pdfFile);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    private File generarPDF(String content) throws IOException {
        // Crear un nuevo documento PDF
        File pdfFile = new File(getContext().getCacheDir(), "Recibo de pago.pdf");
        PdfWriter writer = new PdfWriter(pdfFile);
        PdfDocument pdf = new PdfDocument(writer);
        Document document = new Document(pdf);

        // Obtener la imagen desde los recursos y agregarla al PDF
        Drawable drawable = getResources().getDrawable(R.drawable.sefinsa_ticket);
        BitmapDrawable bitmapDrawable = (BitmapDrawable) drawable;
        Bitmap bitmap = bitmapDrawable.getBitmap();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
        ImageData imageData = ImageDataFactory.create(stream.toByteArray());
        Image image = new Image(imageData);
        document.add(image);

        // Agregar el contenido al PDF
        document.add(new Paragraph(content));

        // Cerrar el documento
        document.close();

        return pdfFile;
    }

    private void compartirPDF(File pdfFile) {
        try {
            Intent intent = new Intent(Intent.ACTION_SEND);
            intent.setType("application/pdf");
            Uri pdfUri = FileProvider.getUriForFile(getContext(), getContext().getApplicationContext().getPackageName() + ".provider", pdfFile);
            intent.putExtra(Intent.EXTRA_STREAM, pdfUri);
            startActivity(Intent.createChooser(intent, "Compartir mediante"));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    private void filtrarReporte(String fecha){

        reporteGeneralFiltrado = new ArrayList<>();
        reporteGeneralFiltrado.clear();

        double total = 0;

        for(ReporteGeneral rg : reporteGeneral){

            if(rg.getFecha_pago_realizada().equals(fecha)){
                total += Utils.convertirDouble(rg.getPago());
                reporteGeneralFiltrado.add(rg);
            }

        }

        tvPago.setText("PAGO ($" + total +")");

        if(!reporteGeneralFiltrado.isEmpty()){
            reporteGeneralAdapter.setListaFiltrada(reporteGeneralFiltrado);
        } else {
            // Si no hay resultados, puedes hacer algo como limpiar el adaptador o mostrar un mensaje.
            // Limpiar el adaptador o mostrar un mensaje de "no se encontraron resultados"
            reporteGeneralAdapter.setListaFiltrada(new ArrayList<>()); // Limpiar la lista en el adaptador
            Toast.makeText(getContext(), "No se encontraron resultados", Toast.LENGTH_SHORT).show(); // O un mensaje similar
        }

    }

    private void filtrarReportePoblacion(String poblacion){
        reporteGeneralFiltrado = new ArrayList<>();
        reporteGeneralFiltrado.clear();

        double total = 0;

        for(ReporteGeneral rg : reporteGeneral){
            if(rg.getNombre_poblacion().equals(poblacion)){
                total += Utils.convertirDouble(rg.getPago());
                reporteGeneralFiltrado.add(rg);
            }
        }

        tvPago.setText("PAGO ($" + total +")");

        if(!reporteGeneralFiltrado.isEmpty()){
            reporteGeneralAdapter.setListaFiltrada(reporteGeneralFiltrado);
        } else {
            // Si no hay resultados, puedes hacer algo como limpiar el adaptador o mostrar un mensaje.
            // Limpiar el adaptador o mostrar un mensaje de "no se encontraron resultados"
            reporteGeneralAdapter.setListaFiltrada(new ArrayList<>()); // Limpiar la lista en el adaptador
            Toast.makeText(getContext(), "No se encontraron resultados", Toast.LENGTH_SHORT).show(); // O un mensaje similar
        }

    }


    private void filtrarReporte(String fecha, String poblacion){
        reporteGeneralFiltrado = new ArrayList<>();
        reporteGeneralFiltrado.clear();
        Log.d("ReporteGeneralFragment", "Datos encontrados, procesando resultados...: fecha:" + fecha + " / " + poblacion);
        for(ReporteGeneral rg : reporteGeneral){

            if(rg.getNombre_poblacion().equals(poblacion) && rg.getFecha_pago_realizada().equals(fecha)){
                reporteGeneralFiltrado.add(rg);
            }
        }

        if (!reporteGeneralFiltrado.isEmpty()) {
            reporteGeneralAdapter.setListaFiltrada(reporteGeneralFiltrado);
        } else {
            // Si no hay resultados, puedes hacer algo como limpiar el adaptador o mostrar un mensaje.
            // Limpiar el adaptador o mostrar un mensaje de "no se encontraron resultados"
            reporteGeneralAdapter.setListaFiltrada(new ArrayList<>()); // Limpiar la lista en el adaptador
            Toast.makeText(getContext(), "No se encontraron resultados", Toast.LENGTH_SHORT).show(); // O un mensaje similar
        }
    }



}